 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 *******************************************************************/
 #include "BSqueue4.h"      // class BSQueue
 #include "message.h"    // class ExternalMessage, InternalMessage
 #include <iostream>
 #include <fstream>
  ofstream BQI ("BS4QIn.txt");
  ofstream BQO ("BS4QOut.txt");

 BSQueue4::BSQueue4( const string &name ) : Atomic( name )
 , IB0( addInputPort( "IB0" ) )
 , IB1( addInputPort( "IB1" ) )
 , IB2( addInputPort( "IB2" ) )
 , IB3( addInputPort( "IB3" ) )
 , IB5( addInputPort( "IB5" ) )
 , IB6( addInputPort( "IB6" ) )
 , IU2( addInputPort( "IU2" ) )
 , Req( addInputPort( "Req" ) )
 , Out( addInputPort( "Out" ) )
 , ProcessTime (00,00,00,00)
 {
 }

 Model &BSQueue4::initFunction()
 {
   Request = 0;
   Qlen = 0;
   state = Idle;
   elements.erase( elements.begin(), elements.end() ) ;
   passivate();
   return *this ;
 }

 Model &BSQueue4::externalFunction( const ExternalMessage &msg )
 { BQI <<msg.time()<<" "<<msg.value()<<"\n";
   if( msg.port() != Req ) // Input from In1 or In2 or In3 or In4
	 {
	   elements.push_back( msg.value() ) ; //Store Input value in Queue
	   state = Push;
	   Qlen++;
	   holdIn( Atomic::active, ProcessTime);
	 }
     else if (elements.size() > 0)  //So msg.port() == Req  ===> Pop from Queue (Check that the Queue is not empty)
          	 {
    	       Request = 1;
    	       state = Pop;
    	       holdIn( Atomic::active, ProcessTime);
      	     }
             else if (elements.size() == 0)
            	     {      // Here this two condition are True :(msg.port() == Req) & (elements.size() == 0)
            	       Request = 1;   // Although Queue is empty but remember that server is waiting for input.
            	       passivate();   // If the queue is empty then passivate.
            	     }
   return *this;
 }

 Model &BSQueue4::outputFunction( const InternalMessage &msg )
 {
   if ((state == Pop) && (Request == 1))
   {
	 sendOutput( msg.time(), Out, elements.front());  // Send out data from Queue
	 BQO <<msg.time()<<" Out "<<elements.front()<<"\n";
   }

   return *this ;
 }

 Model &BSQueue4::internalFunction( const InternalMessage & )
 {
   switch (state){
   				    case Idle:
   				    	       if (Request == 1) state = Pop;
   				    	         else passivate();
   					           break;

   				    case Push:
 			    	            state = Idle;
   					            break;

   				    case Pop:
   				    	       elements.pop_front();
   				    	       Qlen--;
   				    	       Request = 0;
   				    	       state = Idle;
   					           break;
           		 }
   return *this;
 }

 BSQueue4::~BSQueue4()
 {
 }
